// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : |S\vO[ CScene.h ]		Auter : KENSUKE WATANABE
//													Data  : 2016/05/30
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/05/30
//
// ======== ======== ======== ======== ======== ======== ======== ========
#ifndef _SCENE_H_
#define _SCENE_H_

#include "main.h"
#include <list>

// -------- -------- -------- -------- -------- -------- -------- --------
// 萔`
// -------- -------- -------- -------- -------- -------- -------- --------
#define NUM_VERTEX		( 4 )			// _
#define NUM_POLYGON		( 2 )			// |S(v~eBu)
#define MAX_SCENE_PRIORITY	( 8 )		// \D揇

// -------- -------- -------- -------- -------- -------- -------- --------
// NX
// -------- -------- -------- -------- -------- -------- -------- --------
class CScene
{
public:
	typedef enum
	{// IuWFNg̎
		OBJTYPE_NONE = 0,		// 
		PLAYER,					// vC[
		ENEMY,					// G
		GRAVITY_OBJ,			// 
		BULLET,					// e
		EXPLOSION,				// 
		EFFECT,					// GtFNg
		PARTICLE,				// p[eBN
		FIELD,					// 
		FONT,					// 
		OBJTYPE_MAX				// ől
	}OBJTYPE;

	typedef enum
	{// IuWFNg̃NX̎
		CLASSTYPE_NONE = 0,		// 
		SCENE_2D,				// vC[
		SCENE_3DPOLY,			// G
		SCENE_MODEL,			// f
		SCENE_CYLINDER,			// V_[
		SCENE_FIELD,			// tB[h
		SCENE_SKYDOME,			// XJCh[
		CLASSTYPE_MAX			// ől
	}CLASSTYPE;
	
	CScene(int priority);	// 
	~CScene();				// fXgN^

	virtual void Init(void) = 0;	// 
	virtual void Uninit(void) = 0;	// I
	virtual void Update(void) = 0;	// XV
	virtual void Draw(void) = 0;	// `

	static void UpdateAll(int priority);		// wprioritySXV
	static void UpdateAll(void);				// SXV
	static void DrawAll(int priority);			// wpriorityS`
	static void DrawAll(void);					// S`
	static void ReleaseAll(void);				// S[X
	static void TypeRelease(const OBJTYPE &selectObjType);

	// 擾
	const D3DXVECTOR3 &GetPos(void)const{return m_pos;}		// W
	const D3DXVECTOR3 &GetScl(void)const{return m_scl;}		// g嗦
	const D3DXVECTOR3 &GetRot(void)const{return m_rot;}		// px
	const D3DXVECTOR3 &GetSize(void)const{return m_size;}	// TCY
	const int &GetR()const { return m_r; }
	const int &GetG()const { return m_g; }
	const int &GetB()const { return m_b; }
	const int &GetA()const { return m_a; }

	// ݒ
	void SetPos(const D3DXVECTOR3 &pos){m_pos = pos;}		// W
	void SetScl(const D3DXVECTOR3 &scl){m_scl = scl;}		// g嗦
	void SetRot(const D3DXVECTOR3 &rot){m_rot = rot;}		// px
	void SetSize(const D3DXVECTOR3 &size){m_size = size;}	// TCY
	void SetCol(int r, int g, int b, int a) { m_r = r; m_g = g; m_b = b; m_a = a; }

	// Z
	void AddPos(const D3DXVECTOR3 &pos){m_pos += pos;}		// W
	void AddScl(const D3DXVECTOR3 &scl){m_scl += scl;}		// g嗦
	void AddRot(const D3DXVECTOR3 &rot){m_rot += rot;}		// px
	void AddSize(const D3DXVECTOR3 &size){m_size += size;}	// TCY
	void AddCol(const int &r, const int &g, const int &b, const int &a) { m_r += r; m_g += g; m_b += b; m_a += a; }

	// ^Cv
	void SetObjType(OBJTYPE type) { m_objType = type; }			// ɃIuWFNg̃^Cvݒ
	OBJTYPE GetObjType(void)const { return m_objType; }			// IuWFNg^Cv̎擾
	void SetClassType(CLASSTYPE type) { m_classType = type; }	// ɃNX̃^Cvݒ
	CLASSTYPE GetClassType(void)const { return m_classType; }	// NX^Cv̎擾

	// `Dx
	const int &GetPriority(void)const { return m_priority; }	// priority̎擾

	// scene
	static std::list<CScene*> *GetScene(int priority) {
		assert((priority > 0 || priority < MAX_SCENE_PRIORITY) && "PRIORITY̎w肪ԈĂ܂");
		return &m_lisScene[priority];			// V[̐擪
	}

	// Cg
	bool GetLightOff()const { return m_lightOff; }
	void SetLightOff(bool lightOff) { m_lightOff = lightOff; }

protected:
	void Release(void) { m_delete = true; }	// [X
	LPDIRECT3DVERTEXBUFFER9 m_pVtxBuffer;	// Vtxobt@

	D3DXVECTOR3 m_pos;			// W
	D3DXVECTOR3 m_scl;			// g嗦
	D3DXVECTOR3 m_rot;			// ]p
	D3DXVECTOR3 m_size;			// TCY
	int m_r, m_g, m_b, m_a;

	OBJTYPE m_objType;			// IuWFNg̃^Cv
	CLASSTYPE m_classType;		// NX̃^Cv
	int m_priority;				// `Dx

	bool m_lightOff;

private:
	
	static std::list<CScene*> m_lisScene[MAX_SCENE_PRIORITY];
	static int m_numScene[MAX_SCENE_PRIORITY];		// V[̑
	bool m_delete;									// tO
};

#endif
